package gov.va.vinci.dart.rule;

import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.DataSource;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.Location;
import gov.va.vinci.dart.biz.Participant;
import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;
import gov.va.vinci.dart.usr.CustomAuthentication;

import java.util.Map;

import org.springframework.security.core.context.SecurityContextHolder;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestCDWDSSNDEDocumentRuleEvaluator extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
		
		CustomAuthentication token = new CustomAuthentication("DNS", null, "password", "details", "principal");

		try {
			DartObjectFactory.getInstance().getUserManager().login(token);
			SecurityContextHolder.getContext().setAuthentication(token);
		} 
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	@Test
	public void testOne() throws Exception {
		
		Request req = TestAbstractDocumentRuleEvaluator.createARequest();

		((DartRequest)req).setHipaaConsent(false);
		((DartRequest)req).setHipaaWaiver(false);

		DataSource ds = DartObjectFactory.getInstance().getDataSourceDAO().findById(1);
		
		CDWDSSNDEDocumentRuleEvaluator testable = new CDWDSSNDEDocumentRuleEvaluator();
		
		Location primarySite = Location.findById(1);
		Location site = Location.findById(2);

		Map<Integer, DocumentTemplate> map = TestAbstractDocumentRuleEvaluator.getDocumentTemplateHash();

		Assert.assertTrue(testable.isRequired(req, ds, map.get(4), primarySite, false));  // is required
		Assert.assertTrue(testable.isRequired(req, ds, map.get(5), primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), primarySite, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(9), primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), primarySite, false));
		//Assert.assertTrue(testable.isRequired(req, ds, map.get(12), primarySite, false)); // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), primarySite, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(18), primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), primarySite, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), primarySite, false));

		((DartRequest)req).setHipaaConsent(true);

		Assert.assertTrue(testable.isRequired(req, ds, map.get(4), primarySite, false));  // is required
		Assert.assertTrue(testable.isRequired(req, ds, map.get(5), primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), primarySite, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(7), primarySite, false)); // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), primarySite, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(9), primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), primarySite, false));
		//Assert.assertTrue(testable.isRequired(req, ds, map.get(12), primarySite, false)); // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), primarySite, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(18), primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), primarySite, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), primarySite, false));

		((DartRequest)req).setHipaaConsent(false);
		((DartRequest)req).setHipaaWaiver(true);

		Assert.assertTrue(testable.isRequired(req, ds, map.get(4), primarySite, false));  // is required
		Assert.assertTrue(testable.isRequired(req, ds, map.get(5), primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), primarySite, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(9), primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), primarySite, false));
		//Assert.assertTrue(testable.isRequired(req, ds, map.get(12), primarySite, false)); // is required
		Assert.assertTrue(testable.isRequired(req, ds, map.get(13), primarySite, false)); // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), primarySite, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(18), primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), primarySite, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), primarySite, false));

		((DartRequest)req).setHipaaConsent(false);
		((DartRequest)req).setHipaaWaiver(false);

		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), site, false));  
		Assert.assertTrue(testable.isRequired(req, ds, map.get(5), site, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), site, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(9), site, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), site, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), site, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), site, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), site, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), site, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), site, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), site, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), site, false));
		
		((DartRequest)req).setHipaaConsent(true);

		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), site, false));  
		Assert.assertTrue(testable.isRequired(req, ds, map.get(5), site, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), site, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(9), site, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), site, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), site, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), site, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), site, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), site, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), site, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), site, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), site, false));

		((DartRequest)req).setHipaaConsent(false);
		((DartRequest)req).setHipaaWaiver(true);

		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), site, false));  
		Assert.assertTrue(testable.isRequired(req, ds, map.get(5), site, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), site, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(9), site, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), site, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), site, false)); 
		Assert.assertTrue(testable.isRequired(req, ds, map.get(13), site, false)); // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), site, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), site, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), site, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), site, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), site, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), site, false));
	}

	@Test
	public void testTwo() throws Exception {
		
		Request req = TestAbstractDocumentRuleEvaluator.createARequest();
		
		((DartRequest)req).setHipaaConsent(false);
		((DartRequest)req).setHipaaWaiver(false);
		
		DataSource ds = DartObjectFactory.getInstance().getDataSourceDAO().findById(1);
		
		CDWDSSNDEDocumentRuleEvaluator testable = new CDWDSSNDEDocumentRuleEvaluator();
		
		Group ordGroup = DartObjectFactory.getInstance().getGroupDAO().findById(7);
		Group privacyGroup = DartObjectFactory.getInstance().getGroupDAO().findById(3);
		Group ndsGroup = DartObjectFactory.getInstance().getGroupDAO().findById(1);
		
		// non-primary site
		Location site = Location.findById(2);
		
		Map<Integer, DocumentTemplate> map = TestAbstractDocumentRuleEvaluator.getDocumentTemplateHash();

		// loop on all data sources in a request, all sites in a request, and *all* document templates
		
		// no admin documents are required for non-primary sites
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, site, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, site, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, site, false));

		// no admin documents are required for non-primary sites even with HIPAA requirements
		((DartRequest)req).setHipaaConsent(true);
		((DartRequest)req).setHipaaWaiver(true);
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, site, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, site, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, site, false));

		// primary site
		site = Location.findById(1);

		// no admin documents are required for primary site for ord group
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, site, false));

		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(5), ndsGroup, site, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(9), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), ndsGroup, site, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), ndsGroup, site, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(21), ndsGroup, site, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), ndsGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), ndsGroup, site, false));

		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(5), privacyGroup, site, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(9), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), privacyGroup, site, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), privacyGroup, site, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), privacyGroup, site, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(24), privacyGroup, site, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), privacyGroup, site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), privacyGroup, site, false));

	}

	@Test
	public void testThree() throws Exception {
		
		Request req = TestAbstractDocumentRuleEvaluator.createARequest();
		
		((DartRequest)req).setHipaaConsent(false);
		((DartRequest)req).setHipaaWaiver(false);

		// non-primary site
		Location site = Location.findById(2);
		Location primarySite = Location.findById(1);

		// request needs two participants
		Person pers1 = Person.findById(1004);  // primary investigator primary site
		Person pers2 = Person.findById(1005);  // primary site no data access
		Person pers3 = Person.findById(1006);  // primary investigator non-primary site
		Person pers4 = Person.findById(1008);  // non-primary site no data access
		Person pers5 = Person.findById(1014);  // non-primary site with data access
		
		Participant participant1 = Participant.create(pers1, req, primarySite, true, true, true);
		Participant participant2 = Participant.create(pers2, req, primarySite, false, false, false);
		Participant participant3 = Participant.create(pers3, req, site, true, true, true);
		Participant participant4 = Participant.create(pers4, req, site, false, false, false);
		Participant participant5 = Participant.create(pers5, req, site, true, true, false);

		DataSource ds = DartObjectFactory.getInstance().getDataSourceDAO().findById(1);
		
		CDWDSSNDEDocumentRuleEvaluator testable = new CDWDSSNDEDocumentRuleEvaluator();
		
		Map<Integer, DocumentTemplate> map = TestAbstractDocumentRuleEvaluator.getDocumentTemplateHash();

		// loop on all data sources in a request, all sites in a request, and *all* document templates
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, participant2, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, participant4, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, participant5, false));
		
		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(5), participant1, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(9), participant1, false));
		//Assert.assertTrue(testable.isRequired(req, ds, map.get(10), participant1, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), participant1, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), participant1, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), participant1, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), participant1, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), participant1, false));
		
		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(5), participant3, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(9), participant3, false));

		//VA Form 9957 only required for Principal Investigator at the Primary Site
		//Assert.assertTrue(testable.isRequired(req, ds, map.get(10), participant3, false)); // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), participant3, false));

		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), participant3, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), participant3, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), participant3, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), participant3, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), participant3, false));

	}
	
	@Test
	public void testFour() throws Exception {
		
		Request req = TestAbstractDocumentRuleEvaluator.createARequest();
		
		((DartRequest)req).setHipaaConsent(false);
		((DartRequest)req).setHipaaWaiver(false);

		// non-primary site
		Location site = Location.findById(2);
		Location primarySite = Location.findById(1);

		// request needs two participants
		Person pers1 = Person.findById(1004);  // primary investigator primary site
		Person pers2 = Person.findById(1005);  // primary site no data access
		Person pers3 = Person.findById(1006);  // primary investigator non-primary site
		Person pers4 = Person.findById(1008);  // non-primary site no data access
		Person pers5 = Person.findById(1014);  // non-primary site with data access
		
		Participant participant1 = Participant.create(pers1, req, primarySite, true, true, true);
		Participant participant2 = Participant.create(pers2, req, primarySite, false, false, false);
		Participant participant3 = Participant.create(pers3, req, site, true, true, true);
		Participant participant4 = Participant.create(pers4, req, site, false, false, false);
		Participant participant5 = Participant.create(pers5, req, site, true, true, false);

		DataSource ds = DartObjectFactory.getInstance().getDataSourceDAO().findById(1);
		
		CDWDSSNDEDocumentRuleEvaluator testable = new CDWDSSNDEDocumentRuleEvaluator();
		
		Map<Integer, DocumentTemplate> map = TestAbstractDocumentRuleEvaluator.getDocumentTemplateHash();

		Group ordGroup = DartObjectFactory.getInstance().getGroupDAO().findById(7);
		Group privacyGroup = DartObjectFactory.getInstance().getGroupDAO().findById(3);
		Group ndsGroup = DartObjectFactory.getInstance().getGroupDAO().findById(1);

		
		// loop on all data sources in a request, all sites in a request, and *all* document templates

		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, participant1, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, participant2, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, participant3, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, participant4, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, participant5, false));

		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, participant1, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, participant2, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, participant3, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, participant4, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, participant5, false));

		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, participant2, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, participant3, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, participant4, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, participant5, false));

		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(5), ordGroup, participant1, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(9), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), ordGroup, participant1, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), ordGroup, participant1, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), ordGroup, participant1, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), ordGroup, participant1, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(23), ordGroup, participant1, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), ordGroup, participant1, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), ordGroup, participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), ordGroup, participant1, false));

	}

}
